#include <stdio.h>
#include <stdlib.h>

#define CUT_OUT_SIZE 65536

int main(int argc, char **argv){

	FILE *in;
	FILE *out;
	
	char *buffer;

	size_t n;
	
	if(argc < 3){
		fprintf(stderr, "header %d KB cut out program\n", CUT_OUT_SIZE / 1024);
		fprintf(stderr, "Usage:\n  %s infile outfile\n");

		exit(EXIT_FAILURE);
	}

	in = fopen(argv[argc-2], "rb");
	if(in == NULL){
		perror(argv[argc-2]);
		exit(EXIT_FAILURE);
	}

	out = fopen(argv[argc-1], "wb");
	if(out == NULL){
		perror(argv[argc-1]);
		exit(EXIT_FAILURE);
	}

	buffer = (char *)malloc(CUT_OUT_SIZE);

	n = fread(buffer, 1, CUT_OUT_SIZE, in);
	fwrite(buffer, 1, n, out);

	fclose(in);
	fclose(out);

	free(buffer);

	return EXIT_SUCCESS;
}